<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CareerRequest extends Model 
{

    protected $table = 'career_requests';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('career_id', 'country_id', 'first_name', 'last_name', 'email', 'phone', 'country_code', 'file');

    public function career()
    {
        return $this->belongsTo('App\Models\Career');
    }

    public function country()
    {
        return $this->belongsTo('App\Models\Country');
    }

}